//++++++++++++++++++++++++++++++++++++++++++++
// Main enbeffect.fx file
// COPYRIGHT - ZIMMER // BORIS VORONTSOV
//++++++++++++++++++++++++++++++++++++++++++++

#define POSTPROCESS
//POSTPROCESS 
float	EAdaptationMin=0.1;
float	EAdaptationMax=0.1;
float	EToneMappingCurve=1.95;
float	EIntensityContrast=1.6;
float	EColorSaturation=2.3;
float	EToneMappingOversaturation=160.0;
//++++++++++++++++++++++++++++++++++++++++
float	EGamma=1.2;
float	EInBlack=0.0;
float	EInWhite=0.95;
float	EOutBlack=0.0;
float	EOutWhite=1.0;
float	EBrightness=1.0;
float	EContrastGrayLevel=0.01;
float	EContrast=1.0;
float	ESaturation=1.0;
//+++++++++++++++++++++++++++++
//external parameters, do not modify
//+++++++++++++++++++++++++++++
//keyboard controlled temporary variables (in some versions exists in the config file). Press and hold key 1,2,3...8 together with PageUp or PageDown to modify. By default all set to 1.0
float4	tempF1; //0,1,2,3
float4	tempF2; //5,6,7,8
float4	tempF3; //9,0
//x=generic timer in range 0..1, period of 16777216 ms (4.6 hours), w=frame time elapsed (in seconds)
float4	Timer;
//x=Width, y=1/Width, z=ScreenScaleY, w=1/ScreenScaleY
float4	ScreenSize;
//changes in range 0..1, 0 means that night time, 1 - day time
float	ENightDayFactor;
//changes 0 or 1. 0 means that exterior, 1 - interior
float	EInteriorFactor;
//changes in range 0..1, 0 means full quality, 1 lowest dynamic quality (0.33, 0.66 are limits for quality levels)
float	EAdaptiveQualityFactor;
//enb version of bloom applied, ignored if original post processing used
float	EBloomAmount;
//fov in degrees
float	FieldOfView;


texture2D texs0;//color
texture2D texs3;//bloom enb
texture2D texs4;//adaptation enb
texture2D texs7;//palette enb

sampler2D _s0 = sampler_state
{
	Texture   = <texs0>;
	MinFilter = POINT;//
	MagFilter = POINT;//
	MipFilter = NONE;//LINEAR;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D _s3 = sampler_state
{
	Texture   = <texs3>;
	MinFilter = LINEAR;//
	MagFilter = LINEAR;//
	MipFilter = NONE;//LINEAR;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D _s4 = sampler_state
{
	Texture   = <texs4>;
	MinFilter = LINEAR;//
	MagFilter = LINEAR;//
	MipFilter = NONE;//LINEAR;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D _s7 = sampler_state
{
	Texture   = <texs7>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

struct VS_OUTPUT_POST
{
	float4 vpos  : POSITION;
	float2 txcoord0 : TEXCOORD0;
};
struct VS_INPUT_POST
{
	float3 pos  : POSITION;
	float2 txcoord0 : TEXCOORD0;
};



//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
VS_OUTPUT_POST VS_Quad(VS_INPUT_POST IN)
{
	VS_OUTPUT_POST OUT;

	OUT.vpos=float4(IN.pos.x,IN.pos.y,IN.pos.z,1.0);

	OUT.txcoord0.xy=IN.txcoord0.xy;

	return OUT;
}



float4 PS_GTASA(VS_OUTPUT_POST IN, float2 vPos : VPOS) : COLOR
{
	float4 _oC0=0.0; //output
	float4 _v0=0.0;

	_v0.xy=IN.txcoord0.xy;
	_oC0=tex2D(_s0, _v0.xy); //color

	//apply bloom
	float4	xcolorbloom=tex2D(_s3, _v0.xy);

	xcolorbloom.xyz=xcolorbloom-_oC0;
	xcolorbloom.xyz=max(xcolorbloom, 0.0);
	_oC0.xyz+=xcolorbloom*EBloomAmount;

	float4 color=_oC0;


	//adaptation in time
	float4	Adaptation=tex2D(_s4, 0.5);
	float	grayadaptation=max(max(Adaptation.x, Adaptation.y), Adaptation.z);


#ifdef POSTPROCESS

	grayadaptation=max(grayadaptation, 0.0);
	grayadaptation=min(grayadaptation, 50.0);
	color.xyz=color.xyz/(grayadaptation*EAdaptationMax+EAdaptationMin);//*tempF1.x

	//color.xyz*=EBrightness;
	color.xyz+=0.000001;
	float3 xncol=normalize(color.xyz);
	float3 scl=color.xyz/xncol.xyz;
	scl=pow(scl, EIntensityContrast);
	xncol.xyz=pow(xncol.xyz, EColorSaturation);
	color.xyz=scl*xncol.xyz;

	float	lumamax=EToneMappingOversaturation;
	color.xyz=(color.xyz * (1.0 + color.xyz/lumamax))/(color.xyz + EToneMappingCurve);

#endif

	float	tempgray;
	float4	tempvar;
	float3	tempcolor;
/*
	//these replaced by "levels"
	//+++ gamma
	color=pow(color, 1.0/EGamma);

	//+++ brightness like in photoshop
	color=color+ECCAditiveBrightness;

	//+++ lightness
	tempvar.x=saturate(ELightness);
	tempvar.y=saturate(1.0+ELightness);
	color=tempvar.x*(1.0-color) + (tempvar.y*color);
*/
	//+++ levels like in photoshop, including gamma, lightness, additive brightness
	color=max(color-EInBlack, 0.0) / max(EInWhite-EInBlack, 0.0001);
	color=pow(color, EGamma);
	color=color*(EOutWhite-EOutBlack) + EOutBlack;

	//+++ brightness
	color=color*EBrightness;

	//+++ contrast
	color=(color-EContrastGrayLevel) * EContrast + EContrastGrayLevel;

	//+++ saturation
	tempgray=dot(color, 0.3333);
	color=lerp(tempgray, color, ESaturation);

	_oC0.w=1.0;
	_oC0.xyz=color.xyz;
	return _oC0;
}



//switch between vanilla and mine post processing
technique Shader_GTASA 
{
	pass p0
	{
		VertexShader = compile vs_3_0 VS_Quad();
		PixelShader  = compile ps_3_0 PS_GTASA();
                ColorWriteEnable=ALPHA|RED|GREEN|BLUE;
	}
}


